<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Slip Gaji - {{ $gaji->pegawai->nama }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        .header, .footer { text-align: center; }
        .title { font-size: 16px; font-weight: bold; margin-bottom: 10px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #000; padding: 5px; text-align: left; }
        .right { text-align: right; }
        .no-border { border: none; }
        .signature { margin-top: 40px; width: 100%; }
        .signature td { text-align: center; border: none; padding-top: 50px; }
    </style>
</head>
<body>
    <div class="header">
        <div class="title">Slip Gaji Bulanan<br>PT. Budi Perkasa Alam</div>
    </div>

    <table>
        <tr><td><strong>Nama</strong></td><td>{{ $gaji->pegawai->nama }}</td></tr>
        <tr><td><strong>Bulan</strong></td><td>{{ \Carbon\Carbon::parse($gaji->bulan)->isoFormat('MMMM Y') }}</td></tr>
        <tr><td><strong>NIP</strong></td><td>{{ $gaji->pegawai->nip }}</td></tr>
        <tr><td><strong>Jumlah Hadir</strong></td><td>{{ $gaji->jumlah_hadir }} hari</td></tr>
    </table>

    <br>

    <table>
        <thead>
            <tr>
                <th colspan="2">Komponen Penghasilan</th>
                <th colspan="2">Komponen Potongan</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>Gaji Pokok</td>
                <td class="right">Rp {{ number_format($gaji->gaji_pokok, 0, ',', '.') }}</td>
                <td>BPJS Kesehatan (1%)</td>
                <td class="right">Rp {{ number_format($gaji->pot_bpjs_kesehatan, 0, ',', '.') }}</td>
            </tr>
            <tr>
                <td>Uang Makan</td>
                <td class="right">Rp {{ number_format($gaji->total_uang_makan, 0, ',', '.') }}</td>
                <td>BPJS JHT (2%)</td>
                <td class="right">Rp {{ number_format($gaji->pot_bpjs_jht, 0, ',', '.') }}</td>
            </tr>
            <tr>
                <td colspan="2" class="no-border"></td>
                <td>BPJS JPENS (1%)</td>
                <td class="right">Rp {{ number_format($gaji->pot_bpjs_jpens, 0, ',', '.') }}</td>
            </tr>
            <tr>
                <td colspan="2" class="no-border"></td>
                <td>PPh 21</td>
                <td class="right">Rp {{ number_format($gaji->pot_pph21, 0, ',', '.') }}</td>
            </tr>
            <tr>
                <td colspan="2" class="no-border"></td>
                <td>Potongan Absen</td>
                <td class="right">Rp {{ number_format($gaji->pot_absen, 0, ',', '.') }}</td>
            </tr>
            <tr>
                <td colspan="2" class="no-border"></td>
                <td>Potongan Pinjaman</td>
                <td class="right">Rp {{ number_format($gaji->pot_pinjaman, 0, ',', '.') }}</td>
            </tr>

            @if(is_iterable($gaji->tunjangan))
                @foreach ($gaji->tunjangan as $tunjangan)
                    <tr>
                        <td>{{ $tunjangan->nama }}</td>
                        <td class="right">Rp {{ number_format($tunjangan->jumlah, 0, ',', '.') }}</td>
                        <td colspan="2" class="no-border"></td>
                    </tr>
                @endforeach
            @endif

            @if(is_iterable($gaji->potongan))
                @foreach ($gaji->potongan as $potongan)
                    <tr>
                        <td colspan="2" class="no-border"></td>
                        <td>{{ $potongan->nama }}</td>
                        <td class="right">Rp {{ number_format($potongan->jumlah, 0, ',', '.') }}</td>
                    </tr>
                @endforeach
            @endif

            <tr>
                <th>Total Penghasilan</th>
                @php
                    $gajiPokok = $gaji->gaji_pokok ?? 0;
                    $uangMakan = $gaji->total_uang_makan ?? 0;
                    $tunjangan = method_exists($gaji, 'tunjangan') && $gaji->relationLoaded('tunjangan') ? $gaji->tunjangan->sum('jumlah') : 0;
                    $total_penghasilan = $gaji->jumlah_pendapatan > 0 ? $gaji->jumlah_pendapatan : $gajiPokok + $uangMakan + $tunjangan;
                @endphp
                <th class="right">Rp {{ number_format($total_penghasilan, 0, ',', '.') }}</th>
                <th>Total Potongan</th>
                <th class="right">Rp {{ number_format($gaji->total_potongan, 0, ',', '.') }}</th>
            </tr>
            <tr>
                <th colspan="3">Total Gaji Diterima</th>
                <th class="right">Rp {{ number_format($gaji->total_gaji, 0, ',', '.') }}</th>
            </tr>
        </tbody>
    </table>

    <table class="signature">
        <tr>
            <td>Disetujui oleh,</td>
            <td>Diperiksa oleh,</td>
            <td>Diterima oleh,</td>
        </tr>
        <tr>
            <td>( HRD / Keuangan )</td>
            <td>( Atasan Langsung )</td>
            <td>({{ $gaji->pegawai->nama }})</td>
        </tr>
    </table>
</body>
</html>
