{{-- resources/views/gaji/show.blade.php --}}
<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Detail Gaji - {{ $gaji->pegawai->nama }}
        </h2>
    </x-slot>

    <div class="py-8 px-6">
        @php
            $totalTunjangan = is_iterable($gaji->tunjangan) ? collect($gaji->tunjangan)->sum('jumlah') : 0;
            $totalPotonganTambahan = is_iterable($gaji->potongan) ? collect($gaji->potongan)->sum('jumlah') : 0;

            $totalPotongan = $totalPotonganTambahan
                + ($gaji->pot_bpjs_kesehatan ?? 0)
                + ($gaji->pot_bpjs_jht ?? 0)
                + ($gaji->pot_bpjs_jpens ?? 0)
                + ($gaji->pot_pph21 ?? 0)
                + ($gaji->pot_absen ?? 0)
                + ($gaji->pot_pinjaman ?? 0);
        @endphp

        {{-- Ringkasan Gaji --}}
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
            @foreach ([
                ['label' => 'Gaji Pokok', 'value' => $gaji->gaji_pokok, 'color' => 'blue'],
                ['label' => 'Uang Makan', 'value' => $gaji->total_uang_makan, 'color' => 'green'],
                ['label' => 'Total Tunjangan', 'value' => $totalTunjangan, 'color' => 'yellow'],
                ['label' => 'Total Potongan', 'value' => $totalPotongan, 'color' => 'red'],
            ] as $item)
                <div class="bg-white p-4 rounded shadow text-center">
                    <div class="text-sm text-gray-500">{{ $item['label'] }}</div>
                    <div class="text-lg font-bold text-{{ $item['color'] }}-700">
                        Rp {{ number_format($item['value'], 0, ',', '.') }}
                    </div>
                </div>
            @endforeach
        </div>

        {{-- Informasi Umum --}}
        <div class="bg-white p-6 rounded shadow mb-6">
            <h3 class="text-lg font-bold mb-4">Informasi Gaji</h3>
            <table class="w-full text-sm">
                <tr><td class="py-1 w-48">Nama Pegawai</td><td>: {{ $gaji->pegawai->nama }}</td></tr>
                <tr><td>Bulan</td><td>: {{ $gaji->bulan }}</td></tr>
                <tr><td>Tanggal</td><td>: {{ $gaji->tanggal ?? '-' }}</td></tr>
                <tr><td>Jumlah Hadir</td><td>: {{ $gaji->jumlah_hadir }} hari</td></tr>
                <tr><td><strong>Total Gaji</strong></td>
                    <td>: <strong class="text-indigo-700">Rp {{ number_format($gaji->total_gaji, 0, ',', '.') }}</strong></td>
                </tr>
            </table>
        </div>

        {{-- Tunjangan --}}
        @if (is_iterable($gaji->tunjangan) && count($gaji->tunjangan))
            <div class="bg-white p-6 rounded shadow mb-6">
                <h3 class="text-lg font-bold mb-4">Rincian Tunjangan</h3>
                <table class="w-full border text-sm">
                    <thead class="bg-gray-100">
                        <tr><th class="p-2 text-left">Nama Tunjangan</th><th class="p-2 text-right">Jumlah</th></tr>
                    </thead>
                    <tbody>
                        @foreach ($gaji->tunjangan as $tunjangan)
                            <tr>
                                <td class="p-2 border-t">{{ $tunjangan->nama }}</td>
                                <td class="p-2 border-t text-right">Rp {{ number_format($tunjangan->jumlah, 0, ',', '.') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif

        {{-- Potongan Tambahan --}}
        @if (is_iterable($gaji->potongan) && count($gaji->potongan))
            <div class="bg-white p-6 rounded shadow mb-6">
                <h3 class="text-lg font-bold mb-4">Rincian Potongan Tambahan</h3>
                <table class="w-full border text-sm">
                    <thead class="bg-gray-100">
                        <tr><th class="p-2 text-left">Nama Potongan</th><th class="p-2 text-right">Jumlah</th></tr>
                    </thead>
                    <tbody>
                        @foreach ($gaji->potongan as $potongan)
                            <tr>
                                <td class="p-2 border-t">{{ $potongan->nama }}</td>
                                <td class="p-2 border-t text-right">Rp {{ number_format($potongan->jumlah, 0, ',', '.') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif

        {{-- Potongan Tetap --}}
        <div class="bg-white p-6 rounded shadow mb-6">
            <h3 class="text-lg font-bold mb-4">Potongan Tetap</h3>
            <table class="w-full border text-sm">
                <tbody>
                    <tr><td class="p-2 border-t">BPJS Kesehatan</td><td class="p-2 border-t text-right">Rp {{ number_format($gaji->pot_bpjs_kesehatan, 0, ',', '.') }}</td></tr>
                    <tr><td class="p-2 border-t">BPJS JHT</td><td class="p-2 border-t text-right">Rp {{ number_format($gaji->pot_bpjs_jht, 0, ',', '.') }}</td></tr>
                    <tr><td class="p-2 border-t">BPJS JPENS</td><td class="p-2 border-t text-right">Rp {{ number_format($gaji->pot_bpjs_jpens, 0, ',', '.') }}</td></tr>
                    <tr><td class="p-2 border-t font-semibold text-red-700">PPh 21</td><td class="p-2 border-t text-right font-semibold text-red-700">Rp {{ number_format($gaji->pot_pph21, 0, ',', '.') }}</td></tr>
                    <tr><td class="p-2 border-t">Absen</td><td class="p-2 border-t text-right">Rp {{ number_format($gaji->pot_absen, 0, ',', '.') }}</td></tr>
                    <tr><td class="p-2 border-t">Pinjaman</td><td class="p-2 border-t text-right">Rp {{ number_format($gaji->pot_pinjaman, 0, ',', '.') }}</td></tr>
                </tbody>
            </table>
        </div>

        {{-- Tombol Navigasi --}}
        <div>
            <a href="{{ route('gaji.index') }}"
                class="inline-block bg-blue-600 text-white px-4 py-2 rounded shadow">
                ← Kembali ke Daftar Gaji
            </a>
        </div>
    </div>
</x-app-layout>
