<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Absensi;
use App\Models\User;

class AbsensiSeeder extends Seeder
{
    public function run(): void
    {
        $users = User::take(5)->get(); // Ambil 5 user pertama

        foreach ($users as $user) {
            Absensi::create([
                'user_id' => $user->id,
                'bulan'   => '032025', // Maret 2025
                'hadir'   => rand(15, 25),
                'izin'    => rand(0, 3),
                'alpha'   => rand(0, 2),
            ]);
        }
    }
}
