<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('gajis', function (Blueprint $table) {
            $table->decimal('pot_bpjs_jht', 15, 2)->default(0)->after('pot_bpjs_kesehatan');
            $table->decimal('pot_bpjs_jpens', 15, 2)->default(0)->after('pot_bpjs_jht');
            $table->decimal('pot_pph21_non_gaji', 15, 2)->default(0)->after('pot_pph21');
            $table->decimal('jumlah_pendapatan', 15, 2)->default(0)->after('total_potongan');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('gajis', function (Blueprint $table) {
            $table->dropColumn([
                'pot_bpjs_jht',
                'pot_bpjs_jpens',
                'pot_pph21_non_gaji',
                'jumlah_pendapatan',
            ]);
        });
    }
};
