<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('gajis', function (Blueprint $table) {
            // Menambahkan kolom potongan BPJS secara terpisah
            if (!Schema::hasColumn('gajis', 'bpjs_kesehatan')) {
                $table->decimal('bpjs_kesehatan', 15, 2)->default(0)->after('total_potongan');
            }
            if (!Schema::hasColumn('gajis', 'bpjs_jht')) {
                $table->decimal('bpjs_jht', 15, 2)->default(0)->after('bpjs_kesehatan');
            }
            if (!Schema::hasColumn('gajis', 'bpjs_jpens')) {
                $table->decimal('bpjs_jpens', 15, 2)->default(0)->after('bpjs_jht');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('gajis', 'bpjs_kesehatan')) {
            Schema::table('gajis', function (Blueprint $table) {
                $table->dropColumn('bpjs_kesehatan');
            });
        }

        if (Schema::hasColumn('gajis', 'bpjs_jht')) {
            Schema::table('gajis', function (Blueprint $table) {
                $table->dropColumn('bpjs_jht');
            });
        }

        if (Schema::hasColumn('gajis', 'bpjs_jpens')) {
            Schema::table('gajis', function (Blueprint $table) {
                $table->dropColumn('bpjs_jpens');
            });
        }
    }
};
