<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('potongans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('gaji_id')->constrained()->onDelete('cascade');
            $table->string('nama'); // misalnya: Zakat, PPh21
            $table->integer('jumlah'); // nominal potongan
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('potongans');
    }
};
