<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Gaji extends Model
{
    use HasFactory;

    protected $fillable = [
        'pegawai_id',
        'bulan',
        'jumlah_hadir',
        'total_uang_makan',
        'gaji_pokok',
        'total_gaji',
        'total_potongan',
        'jumlah_pendapatan',
        'pot_bpjs_kesehatan',
        'pot_bpjs_jht',
        'pot_bpjs_jpens',
        'pot_bpjs_ketenagakerjaan',
        'pot_pph21',
        'pot_pph21_non_gaji',
        'pot_absen',
        'pot_pinjaman',
    ];


    public function pegawai()
    {
        return $this->belongsTo(Pegawai::class);
    }

    public function tunjangan()
    {
        return $this->hasMany(Tunjangan::class);
    }

    public function potongan()
    {
        return $this->hasMany(Potongan::class);
    }
}
