<?php

namespace App\Helpers;

use App\Models\HariLibur;
use Carbon\Carbon;
use Carbon\CarbonPeriod;

class DateHelper
{
    /**
     * Ambil semua tanggal kerja:
     * - Hari kerja: Senin–Jumat (Senin=1, Jumat=5)
     * - Libur nasional (dari tabel hari_liburs) tidak dihitung
     * - Cuti bersama tetap dihitung (tidak dimasukkan ke hari_liburs)
     */
    public static function getTanggalHariKerja(string $bulan)
    {
        // Ambil awal dan akhir bulan dari parameter input (YYYY-MM)
        $tahunBulan = Carbon::parse($bulan)->format('Y-m');
        $start = Carbon::parse($tahunBulan . '-01');
        $end = $start->copy()->endOfMonth();

        // Periode semua tanggal di bulan tersebut
        $periode = CarbonPeriod::create($start, $end);

        // Ambil semua tanggal libur dari DB hari_liburs dalam rentang bulan tersebut
        $tanggalLibur = HariLibur::whereBetween('tanggal', [$start, $end])
            ->pluck('tanggal')
            ->map(fn($tgl) => Carbon::parse($tgl)->toDateString())
            ->toArray();

        // Filter hanya hari kerja (Senin–Jumat) dan bukan libur nasional
        return collect($periode)->filter(function ($date) use ($tanggalLibur) {
            return in_array($date->dayOfWeek, [
                    Carbon::MONDAY,
                    Carbon::TUESDAY,
                    Carbon::WEDNESDAY,
                    Carbon::THURSDAY,
                    Carbon::FRIDAY
                ]) && !in_array($date->toDateString(), $tanggalLibur);
        })->values();
    }
}
