package controllers

import (
	"database/sql"
	"github.com/jinzhu/gorm"
	m "skripsi/skripsiBackend/models"
	"github.com/go-sql-driver/mysql"

	"github.com/revel/revel"
)

type PilihanJawaban struct {
	*revel.Controller

	DB *gorm.DB
}

func (c PilihanJawaban) Index(ID_soal int) revel.Result {

	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()
	rows, err := db.Query("SELECT * FROM pilihan_jawaban WHERE ID_soal=?", ID_soal)

	if err != nil {
		// revel.ERROR.Println("Query gagal:", err)
		return c.RenderText("Query gagal")
	}
	defer rows.Close()

	pilihanjawabans := []m.PilihanJawaban{}
	for rows.Next() {

		pilihanjawaban := m.PilihanJawaban{}
		if err := rows.Scan(&pilihanjawaban.ID, &pilihanjawaban.ID_soal, &pilihanjawaban.Pilihan, &pilihanjawaban.IsTrue, &pilihanjawaban.IgnoreCase); err != nil {

			return c.RenderText("Baca data gagal")
		}
		pilihanjawabans = append(pilihanjawabans, pilihanjawaban)
	}

	return c.RenderJSON(pilihanjawabans)
}

func (c PilihanJawaban) Create(pilihan m.PilihanJawaban, ID_soal int) revel.Result {
	v := c.Validation
	pilihan.Validate(v)
	if v.HasErrors() {
		return c.RenderText("Validasi gagal")
	}

	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	_, err = db.Exec("INSERT INTO pilihan_jawaban VALUES (?, ?, ?)", ID_soal, pilihan.Pilihan, pilihan.IsTrue, pilihan.IgnoreCase)
	if err != nil {
		if mysqlError, ok := err.(*mysql.MySQLError); ok {
			if mysqlError.Number == 1062 {
				return c.RenderText("Kode room sudah ada")
			}
		}
		//  revel.ERROR.Println("Insert data gagal:", err)
		return c.RenderText("Insert data gagal")
	}
	return c.RenderText("Data pilihan berhasil ditambahkan")
}
