package controllers

import (
	m "skripsi/skripsiBackend/models"

	"database/sql"

	"github.com/go-sql-driver/mysql"

	"github.com/revel/revel"
)

type MataKuliah struct {
	*revel.Controller
}

func (c MataKuliah) Index() revel.Result {
	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	rows, err := db.Query("SELECT * FROM mata_kuliah")
	if err != nil {
		// revel.ERROR.Println("Query gagal:", err)
		return c.RenderText("Query gagal")
	}
	defer rows.Close()

	matakuliahs := []m.MataKuliah{}
	for rows.Next() {
		matakuliah := m.MataKuliah{}
		if err := rows.Scan(&matakuliah.Kode, &matakuliah.Nama, &matakuliah.SKS, &matakuliah.Deskripsi); err != nil {
			// revel.ERROR.Println("Baca data gagal:", err)
			return c.RenderText("Baca data gagal")
		}
		matakuliahs = append(matakuliahs, matakuliah)
	}

	return c.RenderJSON(matakuliahs)
}

func (c MataKuliah) IndexById(kode string) revel.Result {
	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	rows, err := db.Query("SELECT * FROM mata_kuliah WHERE kode_MK=?", kode)

	if err != nil {
		// revel.ERROR.Println("Query gagal:", err)
		return c.RenderText("Query gagal")
	}
	defer rows.Close()

	matakuliahs := []m.MataKuliah{}
	for rows.Next() {
		matakuliah := m.MataKuliah{}
		if err := rows.Scan(&matakuliah.Kode, &matakuliah.Nama, &matakuliah.SKS, &matakuliah.Deskripsi); err != nil {
			// revel.ERROR.Println("Baca data gagal:", err)
			return c.RenderText("Baca data gagal")
		}
		matakuliahs = append(matakuliahs, matakuliah)
	}

	return c.RenderJSON(matakuliahs)
}

func (c MataKuliah) Create(mata_kuliah m.MataKuliah) revel.Result {
	v := c.Validation
	mata_kuliah.Validate(v)
	if v.HasErrors() {
		return c.RenderText("Validasi gagal")
	}

	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		// revel.ERROR.Println("Koneksi database gagal:", err)
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	_, err = db.Exec("INSERT INTO mata_kuliah (Kode_MK, Nama, SKS, Deskripsi) VALUES (?, ?, ?, ?)", mata_kuliah.Kode, mata_kuliah.Nama, mata_kuliah.SKS, mata_kuliah.Deskripsi)
	if err != nil {
		if mysqlError, ok := err.(*mysql.MySQLError); ok {
			if mysqlError.Number == 1062 {
				return c.RenderText("Kode MK sudah ada")
			}
		}
		//  revel.ERROR.Println("Insert data gagal:", err)
		return c.RenderText("Insert data gagal")
	}

	return c.RenderText("Data mata kuliah berhasil ditambahkan")
}

func (c MataKuliah) Update(kode string, matkul m.MataKuliah) revel.Result {
	v := c.Validation
	matkul.Validate(v)
	if v.HasErrors() {
		return c.RenderText("Validasi gagal")
	}

	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	_, err = db.Exec("UPDATE mata_kuliah SET kode_MK=?, nama=?, SKS=?, deskripsi=? WHERE kode_MK=?", matkul.Kode, matkul.Nama, matkul.SKS, matkul.Deskripsi, kode)
	if err != nil {
		// Handle error here
		return c.RenderText("Update data gagal")
	}

	return c.RenderText("Data matkul berhasil diupdate")
}

func (c MataKuliah) Delete(kode string) revel.Result {

	db, err := sql.Open("mysql", revel.Config.StringDefault("db.spec", ""))
	if err != nil {
		return c.RenderText("Koneksi database gagal")
	}
	defer db.Close()

	_, err = db.Exec("DELETE FROM mata_kuliah WHERE Kode_MK=?", kode)
	if err != nil {
		// Handle error here
		return c.RenderText("Delete data gagal")
	}

	return c.RenderText("Data matkul berhasil dihapus")
}
